# - Find mash
# Find the native TOMCRYPT includes and library
#
#  TOMCRYPT_INCLUDE_DIR - where to find tomcrypt.h, etc.
#  TOMCRYPT_LIBRARIES   - List of libraries when using tomcrypt.
#  TOMCRYPT_FOUND       - True if tomcrypt found.


IF (TOMCRYPT_INCLUDE_DIR)
  # Already in cache, be silent
  SET(TOMCRYPT_FIND_QUIETLY TRUE)
ENDIF (TOMCRYPT_INCLUDE_DIR)

FIND_PATH(TOMCRYPT_INCLUDE_DIR tomcrypt.h)

SET(TOMCRYPT_NAMES tomcrypt)
FIND_LIBRARY(TOMCRYPT_LIBRARY NAMES ${TOMCRYPT_NAMES} )

# handle the QUIETLY and REQUIRED arguments and set TOMCRYPT_FOUND to TRUE if
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(TOMCRYPT DEFAULT_MSG TOMCRYPT_LIBRARY TOMCRYPT_INCLUDE_DIR)

IF(TOMCRYPT_FOUND)
  SET( TOMCRYPT_LIBRARIES ${TOMCRYPT_LIBRARY} )
ELSE(TOMCRYPT_FOUND)
  SET( TOMCRYPT_LIBRARIES )
ENDIF(TOMCRYPT_FOUND)

MARK_AS_ADVANCED( TOMCRYPT_LIBRARY TOMCRYPT_INCLUDE_DIR )
